/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.logistics.funnel;

import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.content.logistics.FlapStuffs;
import com.zurrtum.create.client.flywheel.api.instance.Instance;
import com.zurrtum.create.client.flywheel.api.visual.DynamicVisual;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.model.Models;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.client.flywheel.lib.visual.AbstractBlockEntityVisual;
import com.zurrtum.create.client.flywheel.lib.visual.SimpleDynamicVisual;
import com.zurrtum.create.content.logistics.funnel.FunnelBlock;
import com.zurrtum.create.content.logistics.funnel.FunnelBlockEntity;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2350;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

@Environment(value=EnvType.CLIENT)
public class FunnelVisual
extends AbstractBlockEntityVisual<FunnelBlockEntity>
implements SimpleDynamicVisual {
    private final FlapStuffs.Visual flaps;

    public FunnelVisual(VisualizationContext context, FunnelBlockEntity blockEntity, float partialTick) {
        super(context, blockEntity, partialTick);
        if (!blockEntity.hasFlap()) {
            this.flaps = null;
            return;
        }
        class_2350 funnelFacing = FunnelBlock.getFunnelFacing(this.blockState);
        PartialModel flapPartial = this.blockState.method_26204() instanceof FunnelBlock ? AllPartialModels.FUNNEL_FLAP : AllPartialModels.BELT_FUNNEL_FLAP;
        Matrix4f commonTransform = FlapStuffs.commonTransform(this.getVisualPosition(), funnelFacing, -blockEntity.getFlapOffset());
        this.flaps = new FlapStuffs.Visual(this.instancerProvider(), (Matrix4fc)commonTransform, FlapStuffs.FUNNEL_PIVOT, Models.partial(flapPartial));
        this.flaps.update(blockEntity.flap.getValue(partialTick));
    }

    @Override
    public void beginFrame(DynamicVisual.Context ctx) {
        if (this.flaps == null) {
            return;
        }
        this.flaps.update(((FunnelBlockEntity)this.blockEntity).flap.getValue(ctx.partialTick()));
    }

    @Override
    public void updateLight(float partialTick) {
        if (this.flaps != null) {
            this.flaps.updateLight(this.computePackedLight());
        }
    }

    @Override
    protected void _delete() {
        if (this.flaps == null) {
            return;
        }
        this.flaps.delete();
    }

    @Override
    public void collectCrumblingInstances(Consumer<Instance> consumer) {
        if (this.flaps == null) {
            return;
        }
        this.flaps.collectCrumblingInstances(consumer);
    }
}

